import { jsx, jsxs } from "react/jsx-runtime";
import { T as TableHeader } from "./table-header-BdDXN7Km.js";
import { T as Table, a as TableBody, b as TableRow, c as TableCell } from "./table-Lb16Ctse.js";
import { usePage } from "@inertiajs/react";
import { useReactTable, getFilteredRowModel, getSortedRowModel, getCoreRowModel, flexRender } from "@tanstack/react-table";
import { useState, useMemo } from "react";
import { AssignmentColumns } from "./assignment-columns-DRfK6Zcv.js";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "./badge-CnqJovSa.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "date-fns";
import "lucide-react";
import "./assignment-dialog-35Cv6tjl.js";
import "./button-CoRGprmX.js";
import "./dialog-Bzzm0V8u.js";
import "@radix-ui/react-dialog";
import "./tabs-CgNNKgka.js";
import "@radix-ui/react-tabs";
import "./assignment-details-BD_KqM29.js";
import "richtor";
/* empty css                 */
import "./assignment-submission-D2qpp0po.js";
import "./assignment-submission-form-DWjocxat.js";
import "./chunked-uploader-input-DSIqX-Yc.js";
import "./input-BPdrsFAc.js";
import "axios";
import "sonner";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./select-DLRJE4Jo.js";
import "@radix-ui/react-select";
import "./textarea-M8ToDCeU.js";
const Assignments = () => {
  var _a;
  const { props } = usePage();
  const { assignments } = props;
  const [sorting, setSorting] = useState([]);
  const assignmentColumns = useMemo(() => AssignmentColumns, []);
  const table = useReactTable({
    data: assignments,
    columns: assignmentColumns,
    onSortingChange: setSorting,
    getCoreRowModel: getCoreRowModel(),
    getSortedRowModel: getSortedRowModel(),
    getFilteredRowModel: getFilteredRowModel(),
    state: { sorting }
  });
  return /* @__PURE__ */ jsx("div", { className: "space-y-6", children: assignments && assignments.length > 0 ? /* @__PURE__ */ jsx("div", { className: "overflow-hidden rounded-lg border", children: /* @__PURE__ */ jsxs(Table, { className: "border-border border-y", children: [
    /* @__PURE__ */ jsx(TableHeader, { table }),
    /* @__PURE__ */ jsx(TableBody, { children: ((_a = table.getRowModel().rows) == null ? void 0 : _a.length) ? table.getRowModel().rows.map((row) => /* @__PURE__ */ jsx(TableRow, { "data-state": row.getIsSelected() && "selected", children: row.getVisibleCells().map((cell) => /* @__PURE__ */ jsx(TableCell, { children: flexRender(cell.column.columnDef.cell, cell.getContext()) }, cell.id)) }, row.id)) : /* @__PURE__ */ jsx(TableRow, { children: /* @__PURE__ */ jsx(TableCell, { className: "h-24 text-center", children: "No assignments found." }) }) })
  ] }) }) : /* @__PURE__ */ jsx("div", { className: "py-12 text-center", children: /* @__PURE__ */ jsx("p", { className: "text-muted-foreground text-lg", children: "No assignments available for this course yet." }) }) });
};
export {
  Assignments as default
};
